<?php

namespace TCG\Voyager\Models;

use Illuminate\Database\Eloquent\Model;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;
    protected $fillable = array('author_id', 'category_id', 'title', 'seo_title', 'excerpt', 'body', 'slug', 'meta_description', 'meta_keywords', 'status', 'featured');
    protected $visible = array('author_id', 'category_id', 'title', 'seo_title', 'excerpt', 'body', 'slug', 'meta_description', 'meta_keywords', 'status', 'featured');

    public function author()
    {
        return $this->belongsTo('User');
    }

    public function category()
    {
        return $this->hasOne('Category');
    }

}